<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
	require("Net/DNS2.php"); 
	
	function get_dns_cert($name)
	{
		$CI =& get_instance();
		$r = new Net_DNS2_Resolver(array('nameservers' => array('8.8.8.8','23.23.201.204'))); //specify resolver with name servers to query
		try {
			$result = $r->query($name, 'CERT'); //get cert record for given domain/user
		} 
		catch(Net_DNS2_Exception $e) {
			return FALSE;
		}

		$CI->load->helper('cert');
		foreach($result->answer as $rr)
		{
			$parsed_cert = openssl_x509_parse($rr->certificate); //attempt to decode certificate (only works with PEM)
			if(empty($parsed_cert)) { $pem_cert = convert_cert('DER','PEM',$rr->certificate); } //if that didn't work, try converting it to PEM
			if(isset($pem_cert)) { $parsed_cert = openssl_x509_parse($pem_cert); } //parse converted cert
			//if the certificate has been parsed successfully at this point, return the parsed cert, if not, return false
			if(!empty($parsed_cert)) {  return $parsed_cert; }
			else { return FALSE; }
		}
	}